#include <LiquidCrystal.h>

const int boutonvert = 28;
const int boutonrouge = 22;
const int boutonjaune = 24;
const int boutonbleu = 26;

const int ledVert = 44;
const int ledRouge = 42;
const int ledJaune = 48;
const int ledBleu = 46;

LiquidCrystal lcd(8, 9, 4, 5, 6, 7);

int sequence[100];  // Séquence de jeu
int niveau = 0;     // Niveau actuel

void setup() {
  // Initialisation LCD
  lcd.begin(16, 2);
  lcd.print("Bienvenue");
  lcd.setCursor(1, 1);
  lcd.print("RECORD=13");
  delay(2000);
  lcd.clear();

  // Pins des LEDs
  pinMode(ledVert, OUTPUT);
  pinMode(ledRouge, OUTPUT);
  pinMode(ledJaune, OUTPUT);
  pinMode(ledBleu, OUTPUT);

  // Pins des boutons
  pinMode(boutonvert, INPUT);
  pinMode(boutonrouge, INPUT);
  pinMode(boutonjaune, INPUT);
  pinMode(boutonbleu, INPUT);

  randomSeed(analogRead(0)); // Pour générer des séquences aléatoires
}

void loop() {
  lcd.clear();
  lcd.print("Niveau ");
  lcd.print(niveau + 1);
  delay(1000);

  ajouterCouleur();
  afficherSequence();

  if (attendreReponse() == false) {
    lcd.clear();
    lcd.print("Erreur!");
    niveau = 0;
    delay(2000);
  } else {
    lcd.clear();
    lcd.print("Bravo!");
    niveau++;
    delay(1500);
  }
}

// Ajoute une nouvelle couleur à la séquence
void ajouterCouleur() {
  sequence[niveau] = random(0, 4); // 0 à 3
}

// Montre la séquence au joueur
void afficherSequence() {
  for (int i = 0; i <= niveau; i++) {
    allumerLed(sequence[i]);
    delay(500);
    eteindreToutesLesLeds();
    delay(300);
  }
}

// Vérifie la réponse du joueur
bool attendreReponse() {
  for (int i = 0; i <= niveau; i++) {
    int entree = attendreBouton();
    if (entree != sequence[i]) {
      return false;
    }
  }
  return true;
}

// Attend qu'un bouton soit pressé et retourné
int attendreBouton() {
  while (true) {
    if (digitalRead(boutonvert) == HIGH) {
      allumerLed(0);
      attendreRelachement(boutonvert);
      eteindreToutesLesLeds();
      return 0;
    }
    if (digitalRead(boutonrouge) == HIGH) {
      allumerLed(1);
      attendreRelachement(boutonrouge);
      eteindreToutesLesLeds();
      return 1;
    }
    if (digitalRead(boutonjaune) == HIGH) {
      allumerLed(2);
      attendreRelachement(boutonjaune);
      eteindreToutesLesLeds();
      return 2;
    }
    if (digitalRead(boutonbleu) == HIGH) {
      allumerLed(3);
      attendreRelachement(boutonbleu);
      eteindreToutesLesLeds();
      return 3;
    }
  }
}

// Allume la LED correspondante à la couleur
void allumerLed(int couleur) {
  eteindreToutesLesLeds();
  switch (couleur) {
    case 0:
      digitalWrite(ledVert, HIGH);
      lcd.clear();
      lcd.print("aller plus vite");
      break;
    case 1:
      digitalWrite(ledRouge, HIGH);
      lcd.clear();
      lcd.print("aller plus vite");
      break;
    case 2:
      digitalWrite(ledJaune, HIGH);
      lcd.clear();
      lcd.print("aller plus vite");
      break;
    case 3:
      digitalWrite(ledBleu, HIGH);
      lcd.clear();
      lcd.print("aller plus vite");
      break;
  }
}

// Éteint toutes les LEDs
void eteindreToutesLesLeds() {
  digitalWrite(ledVert, LOW);
  digitalWrite(ledRouge, LOW);
  digitalWrite(ledJaune, LOW);
  digitalWrite(ledBleu, LOW);
}

// Attendre que le bouton soit relâché (pour éviter rebonds)
void attendreRelachement(int bouton) {
  while (digitalRead(bouton) == HIGH) {
    delay(10);
  }
  delay(100); // Petit délai anti-rebond
}

