#include <Keypad.h>
#include <LiquidCrystal.h> //mettre nos deux bibliothèques

LiquidCrystal lcd(8, 9, 4, 5, 6, 7); //donner les broches de l'écran lcd

char u = 0; //créer nos quatres chaines de caractères qui seront les 4 chiffres du code
char d = 0;
char t = 0;
char q = 0;

const byte ROWS = 4; //indiquer que notre clavier a 4 lignes
const byte COLS = 3; //indiquer que notre clavier a 3 colonnes

char keys[ROWS][COLS] = { //indiquer les cases de notre clavier et donc les valeurs a retourner
  {'1','2','3'},
  {'4','5','6'},
  {'7','8','9'},
  {'*','0','#'}
};

byte rowPins[ROWS] = {24, 26, 28, 30};    // dire que nos 4 lignes sont une a une les 4 broches présentes
byte colPins[COLS] = {32, 34, 36};    // dire que nos 3 colonnes sont une a une les 3 broches présentes

Keypad keypad = Keypad( makeKeymap(keys), rowPins, colPins, ROWS, COLS ); //créer un clavir a partir des données fournies

void setup(){
  lcd.begin(16, 2); //démarrer l'écran lcd
  lcd.home();

  Serial.begin(9600); //démarrer le moniteur série

  pinMode(48, OUTPUT); //mettre la broche 48 en sortie
}
  
void loop(){
 lcd.setCursor(1, 0);
  lcd.print("Mot de passe :"); // écrire "mot de passe :" sur la ligne du haut et centré

  char key; //créer une chaine de caractère appelée "key"

  while(u == 0){ //tant que la première chaine de caractères = 0 alors...
    key = keypad.getKey(); //mettre la chaine de caractère "key" a la valeur que nous renvoie le clavier
    if(key != NO_KEY) u = key; // si la chaine de caractère "key" recoit une valeur, alors mettre la première chaine de caractère a "key"
  }

  lcd.setCursor(6, 1); //afficher la valeur de notre première chaine de caractère
  lcd.print(u);
  delay(500); //attendre 0.5 secondes
  lcd.setCursor(6, 1); //remplacer la valeur par un tiret pour cacher le code
  lcd.print("-");
  Serial.println(u); //afficher la première valeur dans le moniteur série

  while(d == 0){ //tant que la deuxième chaine de caractères = 0 alors...
    key = keypad.getKey(); //mettre la chaine de caractère "key" a la valeur que nous renvoie le clavier
    if(key != NO_KEY) d = key; // si la chaine de caractère "key" recoit une valeur, alors mettre la deuxième chaine de caractère a "key"
  }
  lcd.setCursor(7, 1); //afficher la valeur de notre deuxième chaine de caractère
  lcd.print(d);
  delay(500); //attendre 0.5 secondes
  lcd.setCursor(7, 1); //remplacer la valeur par un tiret pour cacher le code
  lcd.print("-");
  Serial.println(d); //afficher la deuxième valeur dans le moniteur série

  while(t == 0){ //tant que la troisième chaine de caractères = 0 alors...
    key = keypad.getKey(); //mettre la chaine de caractère "key" a la valeur que nous renvoie le clavier
    if(key != NO_KEY) t = key; // si la chaine de caractère "key" recoit une valeur, alors mettre la troisième chaine de caractère a "key"
  }
  lcd.setCursor(8, 1); //afficher la valeur de notre troisième chaine de caractère
  lcd.print(t);
  delay(500); //attendre 0.5 secondes
  lcd.setCursor(8, 1); //remplacer la valeur par un tiret pour cacher le code
  lcd.print("-");
  Serial.println(t); //afficher la troisième valeur dans le moniteur série

  while(q == 0){ //tant que la quatrième chaine de caractères = 0 alors...
    key = keypad.getKey(); //mettre la chaine de caractère "key" a la valeur que nous renvoie le clavier
    if(key != NO_KEY) q = key; // si la chaine de caractère "key" recoit une valeur, alors mettre la quatrième chaine de caractère a "key"
  }
  lcd.setCursor(9, 1); //afficher la valeur de notre quatrième chaine de caractère
  lcd.print(q);
  delay(500); //attendre 0.5 secondes
  lcd.setCursor(9, 1); //remplacer la valeur par un tiret pour cacher le code
  lcd.print("-");
  Serial.println(q); //afficher la quatrième valeur dans le moniteur série

  delay(500); //attendre 0.5 secondes
  
  if((u=='1') && (d=='2') && (t=='1') && (q=='1')){ // si nos 4 chaines de caractères sont égaux a leur équivalent dans le code alors...
    lcd.setCursor(3, 1);
    lcd.print("Code correct"); //dire que le code est bon
    digitalWrite(48,HIGH); //activer le verrou de la porte
    delay(5000); // attendre 5 secondes
    digitalWrite(48, LOW); // verouiller la porte
  } else { // sinon...
    lcd.setCursor(1, 1); // dire que le code est incorrect
    lcd.print("Code incorrect  ");
  }
  delay(1000); // attendre 1 seconde

  u=0; //mettre nos 4 chaines de caractères a 0
  d=0;
  t=0;
  q=0;

  lcd.setCursor(1, 1); //effacer l'écran lcd
  lcd.print("               ");
}
